///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _PENDINGTRANS_CPP
#define _PENDINGTRANS_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.h>

#include "../Resources/Resource.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedSource/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/Replication.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/PendingTrans.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND hPendingTransDlg = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK PendingTransDialog(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

	static HWND hTablesList = NULL;

    //--------------------------------------------------------------------------

    if(uMsg == WM_INITDIALOG)
    {
		hPendingTransDlg = hWnd;

        char sCaption[1024];
		sprintf_s(sCaption, sizeof(sCaption), "%s :: %s", gsTitleCaption, "Pending Transactions");
		SendMessage(hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)sCaption);
        SendMessage(hWnd, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

		LV_COLUMN MyLVColumb;
		memset(&MyLVColumb, 0, sizeof(MyLVColumb));

		hTablesList = GetDlgItem(hWnd, IDC_TALBES);

        int iLVStyle = LVS_EX_GRIDLINES;
        SendMessage(hTablesList, (UINT)LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM)iLVStyle);

		// Create Listview columbs
        MyLVColumb.cx        = 150;
        MyLVColumb.pszText   = "Transactions";
        MyLVColumb.iSubItem  = 0;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hTablesList, 0, &MyLVColumb);

        MyLVColumb.cx        = 150;
        MyLVColumb.pszText   = "Database";
        MyLVColumb.iSubItem  = 1;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hTablesList, 1, &MyLVColumb);

        MyLVColumb.cx        = 200;
        MyLVColumb.pszText   = "Table";
        MyLVColumb.iSubItem  = 2;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(hTablesList, 2, &MyLVColumb);

		PopPendingTransGrid(hTablesList);

		CenterWindow(hWnd);

        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_COMMAND)
    {
        if(wParam == ID_CLOSE)
        {
			EndDialog(hWnd,0);
			DestroyWindow(hWnd);
			return TRUE;
        }
		
		return FALSE;
    }

	//--------------------------------------------------------------------------

	if(uMsg == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(hWnd, &ThisPS);

        // Any painting should be done here

        EndPaint(hWnd, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_CLOSE) 
    {
        EndDialog(hWnd,0);
        DestroyWindow(hWnd);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool PopPendingTransGrid(HWND hTablesList)
{
	int iItem = 0;
	
	char sTemp[1024];
	int iTempSz = 0;

	CSQL cSQL;
	CRecordSet rsTemp;
	
	LV_ITEM MyLVItem;
	memset(&MyLVItem, 0, sizeof(MyLVItem));

	char sSQL[1024];
	sprintf_s(sSQL, sizeof(sSQL), "SELECT Count([TransDB]), [TransDB], [TransTable]"
		" FROM [%s].[%s].[SQLExch_Trans]"
		" GROUP BY [TransDB], [TransTable]"
		" ORDER BY Count([TransDB]) DESC, [TransDB], [TransTable]",
		gsReplicationDB, gsDefaultDBO);

	if(!cSQL.Connect(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, "Master", gsDBMode))
	{
		MessageBox(NULL,
			"Failed to connect to the SQL server.",
			gsTitleCaption, MB_TASKMODAL|MB_ICONERROR);

		return false;
	}

	cSQL.Execute(sSQL, &rsTemp);

	while(rsTemp.Fetch())
	{
		rsTemp.sColumnEx(1, sTemp, sizeof(sTemp), &iTempSz);
		MyLVItem.pszText = sTemp;
        MyLVItem.mask = LVIF_TEXT;
        MyLVItem.iSubItem = 0;
		MyLVItem.iItem = iItem;
        ListView_InsertItem(hTablesList, &MyLVItem);

		rsTemp.sColumnEx(2, sTemp, sizeof(sTemp), &iTempSz);
        MyLVItem.pszText = sTemp;
        MyLVItem.mask = LVIF_TEXT;
        MyLVItem.iSubItem = 1;
		MyLVItem.iItem = iItem;
        ListView_SetItem(hTablesList, &MyLVItem);

		rsTemp.sColumnEx(3, sTemp, sizeof(sTemp), &iTempSz);
        MyLVItem.pszText = sTemp;
        MyLVItem.mask = LVIF_TEXT;
        MyLVItem.iSubItem = 2;
		MyLVItem.iItem = iItem;
        ListView_SetItem(hTablesList, &MyLVItem);
		iItem++;
	}

	cSQL.Disconnect();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

